<?php

namespace Elementor;

use Qoxag\Core\Elementor\Controls\Qoxag_Layout;
use Qoxag\Core\Elementor\Controls\Qoxag_Post_Query;
use \ElementsKit_Lite\Modules\Controls\Controls_Manager as ElementsKit_Controls_Manager;

if (!defined('ABSPATH')) exit;


class Qoxag_Post_Tab extends Widget_Base
{
    use \Qoxag\Core\Elementor\Traits\Grid_Controls;

    public $base;

    public function get_name()
    {
        return 'post-tab';
    }

    public function get_title()
    {

        return esc_html__('Qoxag Post Tab', 'qoxag');
    }

    public function get_icon()
    {
        return 'eicon-tabs';
    }

    public function get_categories()
    {
        return ['qoxag-elements'];
    }

    protected function register_controls()
    {

        /*
         * Post Grid Settings
         */
        $this->start_controls_section(
            'postgrid_section',
            [
                'label' => esc_html__('Post Grid Settings', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        // repeater should be coming from Qoxag_Post_Query
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'post_cats',
            [
                'label' => esc_html__('Select Categories', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->post_category(),
                'label_block' => true,
                'multiple' => true,
            ]
        );

        $repeater->add_control(
            'tab_title',
            [
                'label' => esc_html__('Tab title', 'qoxag'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'query_post_tabs',
            [
                'label' => __('Post Tabs', 'qoxag'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tab_title' => esc_html__('Add Label', 'qoxag'),
                        'post_cats' => 1,
                    ],
                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );


        $this->add_group_control(
            Qoxag_Post_Query::get_type(),
            [
                'name' => 'query',
                'exclude' => ['posts_per_page_slider_note', 'slides_to_show', 'post_categories', 'post_tags', 'post_tabs']
            ]
        );

        $this->end_controls_section();

        /*
         * Layout Settings
         */

        $this->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        if (class_exists('ElementsKit_Lite')) {
            $this->add_control(
                'block_style',
                [
                    'label' => esc_html__('Block Style', 'qoxag'),
                    'type' => ElementsKit_Controls_Manager::IMAGECHOOSE,
                    'default' => 'block-1',
                    'options' => [
                        'block-1' => [
                            'title' => esc_html__('Style 1', 'qoxag'),
                            'imagelarge' => QOXAG_IMG . '/style/post-block/block1.png',
                            'imagesmall' => QOXAG_IMG . '/style/post-block/block1.png',
                            'width' => '30%',
                            'column'    => '2',
                            'default_layout'    => 'thumb-left',
                            'featured_layout'    => 'thumb-left',
                        ],
                        'block-2' => [
                            'title' => esc_html__('Style 2', 'qoxag'),
                            'imagelarge' => QOXAG_IMG . '/style/post-block/block2.png',
                            'imagesmall' => QOXAG_IMG . '/style/post-block/block2.png',
                            'width' => '30%',
                            'column'    => '2',
                            'default_layout'    => 'thumb-top',
                            'featured_layout'    => 'thumb-bg',
                        ],
                        'block-3' => [
                            'title' => esc_html__('Style 3', 'qoxag'),
                            'imagelarge' => QOXAG_IMG . '/style/post-block/block3.png',
                            'imagesmall' => QOXAG_IMG . '/style/post-block/block3.png',
                            'width' => '30%',
                            'column'    => '1',
                            'default_layout'    => 'thumb-left',
                            'featured_layout'    => 'thumb-bg',
                        ],
                    ],
                ]
            );
        } else {
            $this->add_control(
                'block_style',
                [
                    'label' => esc_html__('Block Style', 'qoxag'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'block-1',
                    'options' => [
                        'block-1' => esc_html__('Style 1', 'qoxag'),
                        'block-2' => esc_html__('Style 2', 'qoxag'),
                        'block-3' =>  esc_html__('Style 3', 'qoxag'),
                    ],
                ]
            );
        }

        $this->add_group_control(
            Qoxag_Layout::get_type(),
            [
                'name' => 'layout',
                'exclude'   => ['layout_style'],
                'fields_options' => [
                    'column_number' => [
                        'default' => '2'
                    ],
                    'thumbnail_image_aspect_ratio' => [
                        'selectors' => [
                            '{{WRAPPER}} .qoxag-grid-single .post-thumbnail' => 'padding-bottom: calc( {{size}} * 100% );',
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        /*
         * Featured Layout Settings
         */

        $this->start_controls_section(
            'featured_layout_section',
            [
                'label' => esc_html__('Featured Post', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Layout::get_type(),
            [
                'name' => 'featured',
                'exclude' => ['layout_style', 'column_number', 'content_align', 'category_style'],
                'fields_options' => [
                    'thumbnail_image_aspect_ratio' => [
                        'selectors' => [
                            '{{WRAPPER}} .first-block .qoxag-grid-single .post-thumbnail' => 'padding-bottom: calc( {{size}} * 100% );',
                        ],
                    ],
                    'show_content' => [
                        'default' => 'yes',
                    ]
                ],
            ]
        );

        $this->add_control(
            'reverse_featured_column',
            [
                'label' => esc_html__('Reverse Featured Column', 'qoxag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'qoxag'),
                'label_off' => esc_html__('No', 'qoxag'),
                'default' => false,
                'return_value' => true,
                'condition' => ['block_style' => ['block-2']],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-post-block .first-block' => 'order: 1',
                ],
            ]
        );

        $this->end_controls_section();

        /*
         * Advanced Ordering Settings
         */

        $this->advance_ordering_controls();

        /*
         * Tab Navigation Style
         */
        $this->tab_nav_style_controls();

        /*
         * Title Style
         */
        $this->title_style_controls();

        /*
         * Image Style
         */
        $this->image_style_controls();

        /*
         * Meta and Category Style
         */
        $this->meta_style_controls();

        /*
         * Content Style
         */
        $this->description_style_controls();

        /*
         * Feature Style
         */

        $this->start_controls_section(
            'section_featured_style',
            [
                'label' => esc_html__('Featured', 'qoxag'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'featured_post_title_typography',
                'label' => esc_html__('Title Typography', 'qoxag'),
                'selector' => '{{WRAPPER}} .first-block .post-heading',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '600',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '18',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '25',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'featured_thumbnail_image_aspect_ratio',
            [
                'label' => esc_html__('Image Aspect Ratio', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'condition' => ['featured_show_thumbnail' => ['yes']],
                'size_units' => ['%'],
                'range' => [
                    '%' => [
                        'min' => 0.01,
                        'max' => 3.0,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0.5,
                ],
                'tablet_default' => [
                    'unit' => '%',
                    'size' => 0.3,
                ],
                'mobile_default' => [
                    'unit' => '%',
                    'size' => 0.5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .first-block .qoxag-grid-single .post-thumbnail' => 'padding-bottom: calc( {{size}} * 100% );',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'featured_thumbnail_img_size',
                'condition' => ['featured_show_thumbnail' => ['yes']],
                'exclude' => ['custom'],
                'include' => [],
                'default' => 'large',
            ]
        );

        $this->add_responsive_control(
            'featured_content_padding',
            [
                'label' => esc_html__('Content Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .first-block .post-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /*
         * Advanced style Style
         */
        $this->start_controls_section(
            'section_wrapper_style',
            [
                'label' => esc_html__('Wrapper Style', 'qoxag'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->advanced_style_controls();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        switch ($settings['block_style']) {
            case 'block-1':
                $block_style_values = array(
                    'column' => '2',
                    'default_layout' => 'thumb-left',
                    'featured_layout' => 'thumb-left'
                );
                break;
            case 'block-2':
                $block_style_values = array(
                    'column' => '2',
                    'default_layout' => 'thumb-top',
                    'featured_layout' => 'thumb-bg'
                );
                break;
            case 'block-3':
                $block_style_values = array(
                    'column' => '1',
                    'default_layout' => 'thumb-left',
                    'featured_layout' => 'thumb-bg'
                );
                break;
            default:
                $block_style_values = array(
                    'column' => '2',
                    'default_layout' => 'thumb-left',
                    'featured_layout' => 'thumb-left'
                );
                break;
        }

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }

    protected function content_template() {}

    public function post_category()
    {

        $terms = get_terms(array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1,
        ));

        $cat_list = [];
        if (!empty($terms)) {
            foreach ($terms as $post) {
                $cat_list[$post->term_id]  = [$post->name];
            }
        }
        return $cat_list;
    }
}
